using System;
using System.IO;
using System.Xml;
using System.Xml.Schema;
 
namespace Example
{
  public class CMain
  {   
    public static void Main()
    {
       XmlDocument xml = new XmlDocument();

       XmlTextReader tr = new XmlTextReader( "dane.xml" );
       XmlValidatingReader reader = new XmlValidatingReader(tr);

       XmlSchemaCollection oSchema = new XmlSchemaCollection();
       oSchema.Add(null, new XmlTextReader( "dane.xsd" ));

       reader.Schemas.Add( oSchema );	    
       reader.ValidationType = ValidationType.Schema;
	    
       reader.ValidationEventHandler += 
         new ValidationEventHandler (ValidationHandler);

       xml.Load( reader );

       Console.WriteLine( "Wczytano plik." );
    }

     public static void ValidationHandler(object sender, 
                                          ValidationEventArgs args)
     {
        Console.WriteLine("*Bd walidacji*");
        Console.WriteLine("\tWaznosc: {0}", args.Severity);
        Console.WriteLine("\tInfo:    {0}", args.Message);
     }
  }
}
